/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.block.entity;

import dev.ftb.extendedexchange.block.entity.AbstractLinkBlockEntity;
import dev.ftb.extendedexchange.inventory.LinkInputHandler;
import dev.ftb.extendedexchange.inventory.LinkOutputHandler;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.config.ProjectEConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLinkInvBlockEntity
extends AbstractLinkBlockEntity {
    private final LinkInputHandler inputHandler;
    private final LinkOutputHandler outputHandler;
    private final LazyOptional<WrappedItemHandler> itemCap;

    public AbstractLinkInvBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, int inputSize, int outputSize) {
        super(type, blockPos, blockState);
        this.inputHandler = new LinkInputHandler(this, inputSize);
        this.outputHandler = new LinkOutputHandler(this, outputSize);
        this.itemCap = LazyOptional.of(() -> new WrappedItemHandler(this.inputHandler, this.outputHandler));
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputHandler.deserializeNBT(tag.m_128469_("Input"));
        this.outputHandler.deserializeNBT(tag.m_128469_("Output"));
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Input", (Tag)this.inputHandler.serializeNBT());
        tag.m_128365_("Output", (Tag)this.outputHandler.serializeNBT());
    }

    @Override
    public void tickServer() {
        ServerPlayer player = this.nonNullLevel().m_142572_().m_6846_().m_11259_(this.getOwnerId());
        LazyOptional knowledgeProvider = player == null ? LazyOptional.empty() : player.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY);
        boolean syncKnowledge = false;
        boolean changeDone = false;
        for (int i = 0; i < this.inputHandler.getSlots(); ++i) {
            ItemInfo fixed;
            long value;
            ItemStack stack = this.inputHandler.getStackInSlot(i);
            if (stack.m_41619_() || (value = ProjectEAPI.getEMCProxy().getValue(stack)) <= 0L) continue;
            if (this.learnItems() && knowledgeProvider.map(arg_0 -> AbstractLinkInvBlockEntity.lambda$tickServer$1(fixed = ProjectEAPI.getEMCProxy().getPersistentInfo(ItemInfo.fromStack((ItemStack)stack)), arg_0)).orElse(false).booleanValue()) {
                syncKnowledge = true;
            }
            long actual = (long)((double)((long)stack.m_41613_() * value) * ProjectEConfig.server.difficulty.covalenceLoss.get());
            this.storedEMC += actual;
            this.inputHandler.setStackInSlot(i, ItemStack.f_41583_);
            changeDone = true;
        }
        if (changeDone) {
            this.m_6596_();
        }
        if (player != null && syncKnowledge) {
            knowledgeProvider.ifPresent(p -> p.sync(player));
        }
        super.tickServer();
    }

    protected boolean learnItems() {
        return false;
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemCap.invalidate();
    }

    public IItemHandler getInputHandler() {
        return this.inputHandler;
    }

    public LinkOutputHandler getOutputHandler() {
        return this.outputHandler;
    }

    public void addToOutput(ItemStack stack) {
        int i;
        ItemStack fixedStack = ProjectEAPI.getEMCProxy().getPersistentInfo(ItemInfo.fromStack((ItemStack)stack)).createStack();
        for (i = 0; i < this.outputHandler.getSlots(); ++i) {
            if (!ItemStack.m_41746_((ItemStack)this.outputHandler.getItemForDisplay(i), (ItemStack)fixedStack)) continue;
            return;
        }
        for (i = 0; i < this.outputHandler.getSlots(); ++i) {
            if (!this.outputHandler.getItemForDisplay(i).m_41619_()) continue;
            this.outputHandler.setStackInSlot(i, fixedStack);
            return;
        }
    }

    @Override
    public NonNullList<ItemStack> getContentsToDrop() {
        NonNullList res = NonNullList.m_122779_();
        for (int i = 0; i < this.inputHandler.getSlots(); ++i) {
            ItemStack stack = this.inputHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            res.add((Object)stack);
        }
        return res;
    }

    private static /* synthetic */ Boolean lambda$tickServer$1(ItemInfo fixed, IKnowledgeProvider p) {
        return p.addKnowledge(fixed);
    }

    private record WrappedItemHandler(LinkInputHandler inputHandler, LinkOutputHandler outputHandler) implements IItemHandler
    {
        public int getSlots() {
            return this.inputHandler.getSlots() + this.outputHandler.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (this.isInput(slot)) {
                return this.inputHandler.getStackInSlot(slot);
            }
            if (this.isOutput(slot)) {
                return this.outputHandler.getStackInSlot(slot - this.inputHandler.getSlots());
            }
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return this.isInput(slot) ? this.inputHandler.insertItem(slot, stack, simulate) : stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int count, boolean simulate) {
            return this.isOutput(slot) ? this.outputHandler.extractItem(slot - this.inputHandler.getSlots(), count, simulate) : ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            if (this.isInput(slot)) {
                return this.inputHandler.getSlotLimit(slot);
            }
            if (this.isOutput(slot)) {
                return this.outputHandler.getSlotLimit(slot - this.inputHandler.getSlots());
            }
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (this.isInput(slot)) {
                return this.inputHandler.isItemValid(slot, stack);
            }
            if (this.isOutput(slot)) {
                return this.outputHandler.isItemValid(slot - this.inputHandler.getSlots(), stack);
            }
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }

        private boolean isInput(int slot) {
            return slot >= 0 && slot < this.inputHandler.getSlots();
        }

        private boolean isOutput(int slot) {
            return slot >= this.inputHandler.getSlots() && slot < this.getSlots();
        }
    }
}

